#include "core.h"
#include "process.h"
#include "master.h"
#include "dbmonitor/db68000.h"
#include "dbmonitor/dbmonitor.h"
#include "rt.h"
#include "dbmon.h"
#include "m68kcore.h"
#include "m68kdbmon.h"
SRCFILE("m68kdbmon.c")

Process	*M68kDbmonMaster::newProcess(Process *pr, char *p, char *s, char* c)
{
	return new M68kDbmonProcess(fd, boardid, pipeid, pr, p, s, c);
}

char *M68kDbmonMaster::proctype()
{
	DebugAttrib dba;
	char *s;

	::dbrequest(fd, boardid, DB_KERNELID, DBR_GETATTRIB, (int)&dba,
		0, sizeof(dba));
	db_ntohsa(&dba.machine, 3);
	if (dba.machine == DBMT_68020)
		s = "68020";
	else if (dba.machine == DBMT_68010)
		s = "68010";
	else
		s = "68000";
	return s;
}

M68kDbmonProcess::M68kDbmonProcess(int f, int b, int pid, Process *sib,
  char *p, char *s, char *c) : DbmonProcess(f, b, pid, sib, p, s, c) {}

Core *M68kDbmonProcess::newCore(int f, int b, int p, Master *m)
{
	return new M68kDbmonCore(f, b, p, this, m);
}

M68kDbmonCore::M68kDbmonCore(int f, int b, int p, Process *pr, Master *m):
  Core(pr,m), DbmonCore(f,b,p)
{
	regsize = sizeof(DebugRegs);
}

int M68kDbmonCore::nregs()
{
	switch (attrib.machine) {
		default:
		case DBMT_68000:
			return DB_NREGS_68000;
		case DBMT_68010:
			return DB_NREGS_68010;
		case DBMT_68020:
			return DB_NREGS_68020;
	}
}

char *M68kDbmonCore::faultname(int code)
{
	switch (state.code) {
		case 0x008:	return "bus error";
		case 0x00C:	return "address error";
		case 0x014:	return "zero divide";
		case 0x018:	return "chk trap";
		case 0x01C:	return "trapv trap";
		case 0x020:	return "privilege violation";
		case 0x024:	return "trace trap";
		case 0x028:
		case 0x02C:	return "emulator trap";
		case 0x034:	return "coprocessor error";
		case 0x038:	return "format error";
		case 0x03C:	return "unintialized interrupt";
		case 0x060:	return "spurious interrupt";
	}
	return DbmonCore::faultname(code);
}
